-- Hate these tables.
local JudgeCmds = {
	TapNoteScore_W1 = THEME:GetMetric( "Judgment", "JudgmentW1Command" ),
	TapNoteScore_W2 = THEME:GetMetric( "Judgment", "JudgmentW2Command" ),
	TapNoteScore_W3 = THEME:GetMetric( "Judgment", "JudgmentW3Command" ),
	TapNoteScore_W4 = THEME:GetMetric( "Judgment", "JudgmentW4Command" ),
	TapNoteScore_W5 = THEME:GetMetric( "Judgment", "JudgmentW5Command" ),
	TapNoteScore_Miss = THEME:GetMetric( "Judgment", "JudgmentMissCommand" )
}

local TNSString = {
	TapNoteScore_W1 = THEME:GetString("TapNoteScore", "W1"),
	TapNoteScore_W2 = THEME:GetString("TapNoteScore", "W2"),
	TapNoteScore_W3 = THEME:GetString("TapNoteScore", "W3"),
	TapNoteScore_W4 = THEME:GetString("TapNoteScore", "W4"),
	TapNoteScore_W5 = THEME:GetString("TapNoteScore", "W5"),
	TapNoteScore_Miss = THEME:GetString("TapNoteScore", "Miss")
}

local HoldCmds = {
	TapNoteScore_CheckpointHit = THEME:GetMetric( "HoldJudgment", "HoldJudgmentCheckHitCommand" ),
	TapNoteScore_CheckpointMiss = THEME:GetMetric( "HoldJudgment", "HoldJudgmentCheckMissCommand" )
}

-- No more tables pls

local c
local player = Var "Player"

local holdCheckpointsSeparate = false

local t = Def.ActorFrame {}

-- The normal main ... thing
t[#t+1] = Def.ActorFrame {
	Name = "MainJudg",
	
	LoadFont("Common Small") .. {
		Name="Judgment";
		InitCommand=cmd(visible,false);
		OnCommand=THEME:GetMetric("Judgment","JudgmentOnCommand");
		ResetCommand=cmd(finishtweening;stopeffect;y,0;diffusealpha,1;visible,false);
	},
	-- LoadFont("Common Normal") .. {
		-- Name="ProtimingDisplay";
		-- InitCommand=cmd(visible,false);
		-- OnCommand=THEME:GetMetric("Protiming","ProtimingOnCommand");
		-- ResetCommand=cmd(finishtweening;stopeffect;diffusealpha,1;visible,false);
	-- },
	
	InitCommand = function(self)
		c = self:GetChildren()
	end,

	JudgmentMessageCommand=function(self, param)
		if param.Player ~= player then return end
		if param.HoldNoteScore then return end

		local theString = TNSString[param.TapNoteScore]
		
		if not theString then return end
		
		self:playcommand("Reset")
		-- Let's judgment animation
		c.Judgment:visible( true )
		c.Judgment:settext( string.upper(theString) ):diffuse(JudgmentToColor(param.TapNoteScore)):
			strokecolor(Color.Black)
		JudgeCmds[param.TapNoteScore](c.Judgment)
	end
}

if holdCheckpointsSeparate then
	-- let's handle this separately because it's annoying me
	-- Double-check to see if it's a hold checkpoint "judgment" - if we're using that kind of display, that is.
	t[#t+1] = LoadFont("Common Normal") .. {
		Name="HoldWarning";
		InitCommand=cmd(visible,false);
		OnCommand=THEME:GetMetric("Judgment","JudgmentOnCommand");
		ResetCommand=cmd(finishtweening;stopeffect;y,-24;diffusealpha,1;visible,false);
		JudgmentMessageCommand=function(self,param)
			if param.Player ~= player then return end
			if param.HoldNoteScore then return end

			local theString = HoldString[param.TapNoteScore]
			if not theString then return end
			
			self:visible(true):settext( string.upper(theString) )
			HoldCmds[param.TapNoteScore](self)
		end
	}
end

return t
